# Where Are We With Human Lice? A Review of the Current State of Knowledge

Edited by: Ryan Oliver Marino Rego, Institute of Parasitology (ASCR), Czechia

# Reviewed by:

Carlo José Freire Oliveira, Universidade Federal Do Triângulo Mineiro, Brazil Sally Jane Cutler, University of East London, United Kingdom

# \*Correspondence:

Nadia Amanzougaghene amanzougaghene_nadia@yahoo.fr Oleg Mediannikov olegusss1@gmail.com

Nadia Amanzougaghene1,2\*, Florence Fenollar 2,3, Didier Raoult 1,2 and Oleg Mediannikov1,2\*

# Specialty section:

This article was submitted to Parasite and Host, a section of the journal Frontiers in Cellular and Infection Microbiology

Received: 15 May 2019   
Accepted: 24 December 2019   
Published: 21 January 2020

# Citation:

Amanzougaghene N, Fenollar F,   
Raoult D and Mediannikov O (2020)   
Where Are We With Human Lice? A Review of the Current State of Knowledge.   
Front. Cell. Infect. Microbiol. 9:474. doi: 10.3389/fcimb.2019.00474

1 Aix Marseille Univ, IRD, AP-HM, SSA, VITROME, Marseille, France, 2 IHU-Méditerranée Infection, Marseille, France, 3 Aix Marseille Univ, IRD, AP-HM, MEPHI, Marseille, France

Pediculus humanus is an obligate bloodsucking ectoparasite of human that includes two ecotypes, head louse and body louse, which differ slightly in morphology and biology, but have distinct ecologies. Phylogenetically, they are classified on six mitochondrial clades (A, B, C, D, E, and F), head louse encompasses the full genetic diversity of clades, while body louse belongs to clades A and D. Recent studies suggested that not only body louse, but also head louse can transmit disease, which warrants greater attention as a serious public health problem. The recent sequencing of body louse genome confirmed that $P .$ humanus has the smallest genome of any hemimetabolous insect reported to date, and also revealed numerous interesting characteristics in the nuclear and mitochondrial genomes. The transcriptome analyses showed that body and head lice were almost genetically identical. Indeed, the phenotypic flexibility associated with the emergence of body lice, is probably a result of regulatory changes, perhaps epigenetic in origin, triggered by environmental signals. Current lice control strategies have proven unsuccessful. For instance, ivermectin represents a relatively new and very promising pediculicide. However, ivermectin resistance in the field has begun to be reported. Therefore, novel opportunities for pest control strategies are needed. Our objective here is to review the current state of knowledge on the biology, epidemiology, phylogeny, disease-vector and control of this fascinating and very intimate human parasite.

Keywords: Pediculus humanus, biology, epidemiology, phylogeny, disease-vector, control

# BIOLOGY, EPIDEMIOLOGY AND GENOMIC OF LICE

Human lice, commonly known as sucking lice, are hemimetabolous insects that belong to the suborder Anoplura (order: Phthiraptera). They pierce the skin of their human hosts and feed on their blood, which is their only diet (Durden and Musser, 1994). More than 530 species have been described and each species parasitizes one or more closely related placental mammalian host species (Durden and Musser, 1994). Two louse species are known to parasite humans, Pediculus humanus and Pthirus pubis (Reed et al., 2007). Pthirus pubis, found in the pubic area and known as the pubic or crab louse (not considered further in this review) belongs to the genus Pthirus, which is shared with gorillas (Pt. gorilla) (Durden and Musser, 1994; Reed et al., 2007). Pediculus humanus belongs to the genus of Pediculus, which is shared with chimpanzees (P. schaeffi) and New World monkey (P. mjobergi) (Durden and Musser, 1994; Reed et al., 2007; Drali et al., 2016a).

Pediculus humanus comprises two ecotypes, which are body lice (P. h. humanus) and head lice (P. h. capitis). These two ecotypes have almost the same morphology but differ in their ecology and have distinct nutritional patterns (Veracx and Raoult, 2012). The head louse lives, breeds, and lays its eggs (nits) at the base of hair shafts and frequently feed on human blood every $_ { \mathrm { 4 - 6 h } }$ (Light et al., 2008b; Veracx and Raoult, 2012). Body louse lives and lays eggs in clothing, feeds less frequently and ingests greater quantities compared with head louse (Light et al., 2008b; Li et al., 2010; Brouqui, 2011). In addition, it lays more eggs and grows faster than head louse (Light et al., 2008b; Li et al., 2010). Furthermore, body louse is more resistant to environmental conditions, can withstand lower humidity and survives longer outside the host (more than $7 2 \mathrm { { h } }$ for the off-host survival) (Veracx and Raoult, 2012).

Head louse infestation is very common worldwide, especially among schoolchildren, whatever their hygiene status, and the transmission occurs mainly by head-to-head contact (Chosidow, 2000). Adults with poor personal hygiene are also commonly affected (Chosidow, 2000). Body louse infestation is less prevalent and is related with poor hygiene and a lack of sanitation, overcrowding, damp, and cold weather conditions (Raoult and Roux, 1999). For that reason, homeless, jail, and refugee populations are predominantly affected (Raoult and Roux, 1999; Brouqui, 2011). In addition to their role as a dangerous disease vector (we will discuss this point in greater detail later in the review), louse infestations cause itching that may lead to intense irritation (Chosidow, 2000; Veracx and Raoult, 2012). Severe itching can lead to excoriations in which a secondary bacterial infection is likely to occur (Chosidow, 2000). Post inflammatory pigmentation is also common in chronically infested persons (Chosidow, 2000).

The recent sequencing and annotation of body louse genome confirmed that P. humanus harbor the smallest known holometabolic insect genome sequenced to date, and revealed interesting information and characteristics on nuclear and mitochondrial genomes. Thus, body louse genome holds great potential for the understanding of the coevolution among lice population, symbionts and pathogens (Kirkness et al., 2010). Its genome about $1 0 8 \mathrm { M b }$ contains 10,773 predicted protein-coding genes and 57 microRNAs (Kirkness et al., 2010). Interestingly, the number of genes related to sensing and responding to the environmental factors were significantly reduced in body louse genome compared to other insect genomes (Kirkness et al., 2010; Pittendrigh et al., 2013). Thus, reflecting its simple life cycle, whereby humans serve as the sole host and human blood as the only diet (Kirkness et al., 2010; Pittendrigh et al., 2013).

Unlike bilateral animals from which the 37 mitochondrial genes are typically arranged on a single circular chromosome, the body and head lice have their genes organized in an unusual architecture of 20 minichromosomes, each minichromosome has a size of $3 { - } 4 \mathrm { k b }$ and has 1–3 genes and a control region (Shao et al., 2012). Notably, this extensively fragmented mitochondrial genome of $P .$ . humanus is a fascinating phenomenon and represents the most radical departure to date in bilateral animals, and may be associated with the loss of the gene involved in mitochondrial genome replication which encodes the mitochondrial single-stranded DNA binding protein (Kirkness et al., 2010; Shao et al., 2012). However, why and how exactly mitochondrial genome became fragmented, are still poorly understood.

Body and head lice host the same primary endosymbiotic bacteria (Candidatus Riesia pediculicola) that supply the lice with B-vitamins, absent in the human blood (Kirkness et al., 2010; Boyd and Reed, 2012). Candidatus Riesia pediculicola has a small genome that encodes ${ < } 6 0 0$ genes distributed between a short linear chromosome $( \sim 0 . 5 7 \mathrm { M b } )$ ) and a circular plasmid $( \sim 8 \mathrm { k b } )$ including genes required for the synthesis of essential B vitamins (Kirkness et al., 2010; Boyd et al., 2017). The bacterium is housed in specialized structures known as mycetomes, localized on the ventral side of the midgut, and is vertically transmitted from the female louse to its progeny (Perotti et al., 2007). It belongs to the family of Enterobacteriaceae within the Candidatus Riesia genus, which is shared with lice that parasitize chimpanzees and gorillas (Perotti et al., 2007; Boyd et al., 2017). Phylogenetic studies have shown that the symbiont co-evolved with head and body lice and shared a common ancestor with P. schaeffi endosymbiont (Candidatus Riesa pediculischaeffi) roughly 5.4 Mya ago (Boyd et al., 2017). Lice endosymbionts might also support investigations on human evolution (Boyd et al., 2017).

Moreover, in addition to being fundamental to lice development and survival, which makes it an interesting target for the development of an alternative lice control strategy (we will discuss this point in detail later in the review), the question of whether this symbiont has an influence on lice behavior or competence as a disease vector merits further study.

# PHYLOGENY AND PHYLOGEOGRAPHY OF LICE

# Phylogeny Relationships Between Head and Body Lice

The body and head lice have a morphology and biological characteristics almost similar, but differ in their ecological niches (Veracx and Raoult, 2012). Although the taxonomic status of these two types of lice has been debated for more than a century, they are now considered as ecotypes of a single species as opposed to distinct species (Light et al., 2008b; Veracx and Raoult, 2012; Tovar-Corona et al., 2015). Despite numerous studies, the genetic basis and evolutionary relationships among body and head lice remain obscure.

Until recently, the most predominant opinion was that body louse descended from head louse in nature (Veracx and Raoult, 2012). Indeed, as the body louse lives and lays eggs on the clothing of the host (Raoult and Roux, 1999; Light et al., 2008b; Veracx and Raoult, 2012), it was thought that body lice had only recently appeared when modern humans started wearing clothes (Kittler et al., 2003; Light et al., 2008b). However, the most recent data available do not share the same view. Indeed, a novel theory for the emergence of body lice has been reported recently, suggesting that under certain conditions of poor hygiene, an infestation of head lice can turn into a massive infestation, which has allowed variants (genetic or phenotypic) of head lice able of ingesting a large amount of blood, a typical characteristic of body lice, to colonize clothing (Li et al., 2010; Brouqui, 2011; Veracx and Raoult, 2012). This assumption was based on the genotypic and phylogenetic analyses using highly variable intergenic spacers showing that head and body lice are not indistinguishable (Li et al., 2010). In addition, several researchers pointed that when head lice raised under appropriate conditions, they could develop into body louse ecotypes (Keilin and Nuttall, 1919; Alpatov and Nastukova, 1955). Thus, the divergence of head and body lice is obviously not the result of a single event, but probably takes place constantly among the two shared louse clades A and D (see below for louse mitochondrial clades), this transformation being facilitated by mass infestations (Li et al., 2010; Veracx and Raoult, 2012).

Moreover, the comparison of head and body louse transcriptomes has revealed that among the 14 genes with differential expression, only one gene was thought to be missing in head louse, which is the PHUM540560 gene that encodes a hypothetical 69-amino acids protein of unknown function (Olds et al., 2012). A thorough analysis conducted by Drali et al. (2013) revealed that this gene was also present in the head louse but with a rearranged sequence compared to body louse. Notably, based on the variation of this gene, a molecular tool based on real-time PCR has been developed and allows for the first time to differentiate between the two ecotypes (Drali et al., 2013). These findings indicate that head and body lice have almost the same genomic content; therefore, their phenotypic difference is likely to be associated with a variation in gene expression (Olds et al., 2012; Veracx and Raoult, 2012).

Indeed, a recent study analyzed alternative splicing using previously reported transcriptome data for both head and body lice, and reported evidence of differences between transcription pools (Tovar-Corona et al., 2015). Interestingly, while no genes functional categories associated with louse-specific alternative splicing events were found to be overexpressed, genes containing body louse-specific alternative splicing events were found to be significantly enriched for functional categories associated with development of the nervous system and feeding, and ovarian follicle cells, as well as regulation of transcription (Tovar-Corona et al., 2015). For example, the observed enrichment of functional categories related to feeding, in particular the development of salivary gland and open tracheal system, may reflect the adaptation of body lice to more sporadic dietary habits in the clothing environment compared with the more continuous feeding of head lice (Tovar-Corona et al., 2015). Alternative splicing is through to be a major contributor to proteome diversification (Nakka et al., 2018). Indeed, several studies have strongly associated alternative splicing with phenotypic plasticity in eusocial insects, where distinct regulatory programs and phenotypes derive from a single genome (Lyko et al., 2010; Terrapon et al., 2014). Thus, the changes in the development program observed in body lice compared to head lice, may underpin some of the phenotypic flexibility observed in body lice allowing them to colonize clothing (Tovar-Corona et al., 2015).

Taken together, these data evidence that the phenotypic shifts associated with the emergence of body lice are likely to be a consequence of regulatory changes, possibly epigenetic in origin, triggered by environmental cues. Such phenotypic modification has been reported to occur in other insects, such as in honey bees, termites, and migratory locusts (Simpson et al., 2001; Hayashi et al., 2007; Lyko et al., 2010). For example, in honey bees, the development of queens and workers is strictly controlled by the differential feeding of royal jelly and their adult behaviors are accompanied by epigenomic changes (Lyko et al., 2010). Certainly, further efforts on the genetic studies of head and body lice are needed to link their genetic difference with phenotypic differences. Whole genome sequencing of head lice and comparative genomics combined with transcriptomic, proteomic, and epigenomic studies between head and body lice would be useful to better understand lice and address these questions.

# Louse Mitochondrial Clades

Genetic studies based on mitochondrial genes have inferred to Pediculus lice a robust phylogenetic classification into several divergent clades or haplogroups, exhibiting some geographic differences (Figure 1) (Light et al., 2008b; Ashfaq et al., 2015; Drali et al., 2015b; Amanzougaghene et al., 2017). Six mitochondrial clades were described (A, D, B, F, C, and E) (Ashfaq et al., 2015; Drali et al., 2015b; Amanzougaghene et al., 2016b, 2017, 2019). In addition to the inter clade diversity, human lice also display intra clade diversity, as illustrated by the multiple distinct haplotypes for each clade (Figure 1B) (Ascunce et al., 2013; Ashfaq et al., 2015; Amanzougaghene et al., 2016a; Drali et al., 2016a). Head lice encompass all clades diversity, while body lice belong to clades A and D only (Amanzougaghene et al., 2017).

Clade A is widely and globally distributed, while clade D has so far only been reported in sub-Saharan African countries, including the Democratic Republic of Congo (DRC) and the Republic of Congo (Congo-Brazzaville), where it was characterized for the first time among the Pygmy populations (Ascunce et al., 2013; Ashfaq et al., 2015; Drali et al., 2015b; Amanzougaghene et al., 2016a). The clade D was also found in Zimbabwe and Ethiopia (Amanzougaghene et al., 2016a, 2019). Clade B is mainly found in America, where it exhibits a high diversification (Reed et al., 2004; Light et al., 2008a; Ascunce et al., 2013). This clade is also found in Western Europe, Australia, North Algeria, South Africa, Saudi Arabia, and in Israel among head lice remains dating back to the Roman period (Raoult et al., 2008; Ascunce et al., 2013; Ashfaq et al., 2015; Boutellis et al., 2015; Al-Shahrani et al., 2017). Clade F is the sister group of clade B. This clade was first described in head lice recovered from members of the Wayampi community living in a remote Trois-Sauts village, located in French Guiana. This clade was also found in Argentina and Mexico (Amanzougaghene et al., 2019). Pediculus mjobergi, the lice of South American monkeys of Cebidae family, also belong to this clade. These lice are supposed to be acquired by their monkey’s hosts from the first peoples who penetrated the New World across the Bering straits thousands of years ago (Drali et al., 2016a; Amanzougaghene et al., 2019).

Clade C has been reported mainly from two continents, Africa (from Ethiopia and the Republic of Congo) and Asia (Nepal, Pakistan, and Thailand) (Sunantaraporn et al., 2015; Amanzougaghene et al., 2016a, 2017). Lastly, clade E was chiefly found in head lice from West African countries (in Senegal and Mali) (Amanzougaghene et al., 2017, 2019). This clade was also frequently recovered from migrants communities coming mainly from West African countries, as is the case of its detection among Nigerian refugees in Algeria and from migrant communities living in Bobigny, France (Candy et al., 2018a; Louni et al., 2018). Taken together, these data support the idea that all these louse clades accompanied our hominid ancestors since their migrations out of Africa (Li et al., 2010; Amanzougaghene et al., 2017).

![](images/091ddbd0086812669701165de7ad82cd72ce82bcb39e7c8c73b8b39483b8b45b.jpg)  
FIGURE 1 | Phylogeography of body and head lice haplogroups. (A) Neighbor-joining tree based on Cytb haplotypes. (B) Median Joining Network representing the existing relationships between different haplotypes. Pie colors and sizes in circles represent the continents and the number of their sequence for a haplotype. (C) Maps of the world showing the distribution of louse clades.

# Lice as Marker of Human Evolution

Because human lice are highly host specific and have been evolving in tandem with their primate hosts for a thousand of years, they offer a unique feature to reconstruct human migration and human evolutionary history, thereby complementing the hominin fossil records (Reed et al., 2004; Boutellis et al., 2014; Perry, 2014). Studies to date have only started to exploit this invaluable source of precious information (Perry, 2014). Indeed, phylogenetic analyses of Pediculus lice have confirmed some events in the human evolution. For instance, lice of human (P. humanus) and those of chimpanzee (P. schaeffi) have shared a common ancestor about 6 million years ago, which appears to be meeting to the estimated date for the divergence of their respective hosts (Reed et al., 2004, 2007). The lice population presents the genetic signature of a recent demographic expansion that occurred roughly 100,000 years ago, coinciding with the out-of-Africa expansion of modern human hosts, allowing us to use lice to learn about human migration, such as the travel itinerary and the timing of peopling the New Word (Reed et al., 2004; Ascunce et al., 2013). Reed et al. (2004) suggested that two ancient head louse clades (B and C), which originated before modern Homo sapiens, were from archaic hominins (Reed et al., 2004). They found that clade B head lice diverged from clade A between 0.7 and 1.2 Mya, and may have evolved on Neanderthals populated the Eurasian continent, whereas clade C is even more ancient (ca. 2 Mya) and may have evolved on H. erectus (Reed et al., 2004). Because head lice are primarily transmitted horizontally through a physical contact host-to-host, these data support the view of the existence of a direct contact of modern humans with archaic hominin species, and from which they have acquired a distinct lineages of head lice (Reed et al., 2004).

Lice have also helped to elucidating events in the history of human evolution that are absent or uncertain from host fossil or host DNA (Raoult et al., 2008), such as the date on which $H .$ sapiens started wearing clothing by estimating the age of onset of the body louse, which would have evolved only after humans had worn these clothes since this louse lives exclusively in clothing (Kittler et al., 2003). As recently suggested by Toups et al. (2011), based on the molecular dating of body louse, the use of clothing would have started between 83,000 and 170,000 years previous to what was expected (anywhere from $4 0 ~ \mathrm { K a }$ to 3 Ma based on the emergence of eyed needles and the loss of body hair), and the use of clothing by H. sapiens probably originated in Africa and may have made it easier for them to move during frosty weathers as they traveled outside Africa and possibly around the planet earth (Toups et al., 2011).

All these studies demonstrate how lice can provide us with information about the mysteries of our evolution. Further studies on lice and other specific human host parasites, which carry a written record of our past in their DNA, will clarify other events of the human history, while extinct hominid species no longer exist to give us clues about our origins.

# Paleoentomology

Paleoentomological investigations can provide relevant information on the antiquity of lice and their relationship with humans, ancient human migrations across the world and their sanitary conditions (Amanzougaghene et al., 2016b; Drali et al., 2016b). Human lice are most likely among the oldest permanent ectoparasites of humans (Mumcuoglu, 2008; Boutellis et al., 2014). In the Bible, louse infestations are described as the third plague (Mumcuoglu, 2008). Louse infestations of the ancient inhabitants of the Middle East have also been evidenced from the Sumerian, Akkadian, and Egyptian sources (Mumcuoglu, 2008). Moreover, the fossil record of lice and nits from different archaeological sites around the world has expanded greatly over the last 20 years (Drali et al., 2016b).

The oldest head louse nits were found on hair sample collected from an archaic human skeleton found in an archeological site in northeastern Brazil (Araújo et al., 2000). These samples were dated approximately to more than 10,000 years old, demonstrating that the lice were introduced into the New World through the earliest peoples (Araújo et al., 2000). In the Old World, the oldest head louse remains were recovered from an individual who lived in the Nahal Hemar cave near the Dead Sea in Israel during the Neolithic era, 9,000 years ago (Mumcuoglu, 2008). Head lice and their eggs have been recovered on mummified remains in Egypt, China, the Aleutian Islands, Greenland and South America (Drali et al., 2016b). Head lice combs from about 6,500 years ago, very similar to modern lice combs, were already used for delousing in the Pharaonic era in Egypt (Mumcuoglu, 2008). Head lice and their nits have been recovered in combs from different archaeological excavations sites in Egypt and Israel (Mumcuoglu, 2008; Drali et al., 2015a, 2016b; Amanzougaghene et al., 2016b).

The DNA analysis conducted on ancient louse samples provided valuable information to record past genetic structure and diversity of Pediculus lice that can be exploited to reconstruct ancient human evolutionary events (Amanzougaghene et al., 2016b; Drali et al., 2016b). However, so far, only a few genetic studies have focused on the remains of ancient lice. Thus, phylogenetic analysis of the remains of head lice eggs dating from the Chalcolithic and early Islamic periods found in Israel has shown that these remains can be associated with people from West Africa because they belonged to the mitochondrial subclade C (now known as clade E) specific to this region (Drali et al., 2015a). The analysis of pre-Columbian mummies’ lice revealed that head lice belonged to clade A, had a pre-Columbian presence in the America, and would therefore be linked to the Old World (Raoult et al., 2008). Subsequent study conducted by Boutellis et al. (2013a) endorsed this finding and further reported that the presence of clade B head lice on the American continent dates back more than 4,000 years, before the arrival of European settlers, which support an American origin for this clade (Boutellis et al., 2013a). However, this hypothesis has been challenged by its recent discovery among the remains of head lice from 2,000 years ago, found in Israel, supporting a Middle Eastern origin for this clade, followed by its introduction to the American continent with the first people who set up there (Amanzougaghene et al., 2016b).

# LICE-BORNE BACTERIAL DISEASE

# Body Louse Associated Pathogens

Body louse is the major vector of three humans pathogenic bacteria, which are: Rickettsia prowazekii, Borrelia recurrentis, and Bartonella quintana (Figure 2) (Raoult and Roux, 1999; Brouqui, 2011). All these three bacterial pathogens have genomes that are smaller in size than their free-living close relatives (Veracx and Raoult, 2012). Body lice acquire infection during blood meals from an infected patient, carrying this infection for the remainder of their short life (Raoult and Roux, 1999). The transmission of these infections to uninfected people occurs through the feces or crushed bodies of infected lice, that contaminate the bite sites, conjunctiva, mucous membranes or microlesions of the skin (Raoult and Roux, 1999).

Rickettsia prowazekii is the causative agent of epidemic typhus, which caused significant health problems in times of war and social disorder (Raoult and Roux, 1999; Bechah et al., 2008). Despite the effectiveness of antibiotic treatment, the disease remains a serious health threat because it can reoccur at any time (Bechah et al., 2008; Brouqui, 2011). Indeed, healed patients can keep the infection from it for life and, under stressful conditions, the outbreak can occur as milder typhus, Brill-Zinsser’s disease, which could be a source of new outbreaks if lice reappear (Bechah et al., 2008; Brouqui, 2011). Furthermore, since the infection with R. prowazekii can occur by inhalation, the bacterium is also classified as a biological selective agent (Bechah et al., 2008).

Borrelia recurrentis is a spirochete that causes relapsing fever (Raoult and Roux, 1999). In the past, massive epidemics have affected Africa and Eurasia, but nowadays the disease has persisted, particularly in Ethiopia and in other surrounding countries, and has recently emerged among travelers returning from endemic areas in Europe and North America (Bonilla et al., 2013; Antinori et al., 2016a,b).

Bartonella quintana, is well-known as the causative agent of trench fever, but it may also cause clinical manifestations, including chronic bacteremia, bacillary angiomatosis and endocarditis (Raoult and Roux, 1999; Brouqui, 2011). The disease was widespread in France during the Napoleonic Wars (1803–1815) and the two world wars (Raoult and Roux, 1999;

![](images/56690eb005f653aa132857c20f73cd73183c2b14a4ca1c3fa6089a76d959a3b3.jpg)  
FIGURE 2 | Body and head lice associated bacterial pathogens.

Raoult et al., 2006). Currently, it is considered as a re-emerging pathogen in poor countries, and among homeless populations in the developed countries (Brouqui, 2011). It has long been agreed that B. quintana was transmitted only by body louse on humans, which is thought to be the sole reservoir. However, some human cases of B. quintana infection have been associated with kittens and flea-infested kittens (Raoult et al., 1994; Drancourt et al., 1996). The bacterium was also recovered from a cat’s dental pulp (La et al., 2005) and in cat fleas collected in France (Rolain et al., 2003). These data suggest that cats may serve as reservoir hosts for $B _ { \circ }$ . quintana and may follow a transmission mode similar to that described for B. henselae in cat-scratch disease. In addition, Pedicinus obtusus lice and their macaque host have also been implicated in the transmission cycle of B. quintana (Li et al., 2013; Sato et al., 2015). The role of head louse as additional vector was also raised and discussed thereafter.

The combined evidence from laboratory and epidemiological studies strongly implicates body lice as a vector of Yersinia pestis, the causal agent of plague (Houhamdi et al., 2006; Piarroux et al., 2013). Body lice could be involved in plague pandemics that would better match the epidemiology of louse borne infections, this hypothesis has been established by paleomicrobiological studies (Raoult, 2016).

Moreover, the potential role of body louse as vectors for other pathogenic bacteria has also been suspected (Figure 2). Indeed, studies showed that experimentally infected body lice have the potential to acquire, to sustain and to transmit R. conorii (Mediterranean spotted fever, Indian tick typhus), R. rickettsii (Rocky Mountain spotted fever), which are both transmitted by ticks, and R. akari (rickettsial pox) and R. typhi (endemic or murine typhus), which are typically transmitted, respectively, by acari mites and insect fleas (Weyer, 1952; Houhamdi et al., 2003; Houhamdi and Raoult, 2006b). Furthermore, during an outbreak of murine typhus that occurred in northern China and India (Kashmir State), R. typhi has been isolated from body lice infesting the sick patients (Liu, 1944; Kalra and Rao, 1951). Initial field observations in East Africa reported that body lice recovered from an area where a Q fever outbreak that had took place 3 months before had been able to transmit Coxiella burnetii to guinea pigs (Giroud and Jadin, 1954; Babudieri, 1959). Subsequently, it was reported that C. burnetii infection of body lice could occur under experimental conditions (Babudieri, 1959). Other bacteria species, such as Serratia marcescens Acinetobacter baumannii and A. lwoffii have been linked with body lice, assuming that body lice may also transmit these agents (La Scola et al., 2001; Houhamdi and Raoult, 2006a).

Together, these studies suggested that body lice may carry a broad spectrum of pathogens bacteria. In addition, as bloodfeeder insect lice are predisposed to absorb many other types of microorganisms, including viruses and hemoparasites, when they feed on their human host (such as Babesia or Plasmodium). Theoretically, it is possible that lice can transmit any of these agents, if they are ingested with blood meal and if they are able to survive in the insect’s midgut (Raoult and Roux, 1999).

Moreover, the very reduced genome of human lice lacks many genes associated with immune response, odorant and gustatory receptors and detoxifying enzymes (Kirkness et al., 2010; Lee et al., 2010; Previte et al., 2014). The reduced number of defense mechanisms may facilitate the louse infection by different microorganisms. Furthermore, a recent study suggested that body louse phagocytes might host microbes and could be reservoirs for several unidentified pathogens (Coulaud et al., 2015). Therefore, the role of body lice as vectors of these microorganisms is an interesting research topic that deserves to be addressed in future studies.

# Head Louse Associated Pathogens

In recent decades, there has been a growing recognition that head lice are vectors of pathogens, which has changed the longestablished paradigm that only body lice are vectors of disease. Although it is currently agreed that body lice are the most powerful vectors of pathogens, the potential of head lice as disease vector is not yet fully understood.

Recently, several studies have performed comparative analyses in the immune responses following the bacterial challenge using in vitro-rearing system and have shown that body lice relative to head lice show a significant reduction in immune responses, particularly at the onset of the immune challenge (Kim et al., 2011, 2012, 2017; Previte et al., 2014). In one study in particular, Kim et al. (2017) demonstrated that, as in the case of body lice, head lice can withstand a persistent charge of B. quintana infection for several days following the acquisition in a bloodmeal and spread in their feces viable bacteria. However, the rates of proliferation in the gut and numbers of viable B. quintana in the feces were significantly lower in head lice compared to body lice (Kim et al., 2017). For example, in body lice, the B. quintana proliferation rate in the gut was significantly higher (2.0–12.1-fold) over time when compared with head lice until 12 days post-challenge. The viability index of B. quintana in the feces over the entire 11 days post-challenge was 6.4–10.6-fold higher in body lice compared to head lice (Kim et al., 2017). The reduction of the immune response in body lice may be partly the consequence for their increased competence as a vector, compared to head lice (Kim et al., 2011, 2012, 2017; Previte et al., 2014), which develop a more effective immune response to restrict bacterial replication.

Indeed, following B. quintana oral challenge, the transcriptional analysis of the immune response of the alimentary tract of body lice, revealed a reduction in the level of transcription of the main immune genes, including peptidoglycan recognition protein, defensins, and defensin 1, when compared to head lice. How this transcription repression occurs in body lice remains currently unknown (Kim et al., 2012, 2017). Kim et al. (2017) suggested that this regulation may be a consequence of regulatory changes in the epigenetic pathways and in the post-transcriptional miRNA-mediated factors (Kim et al., 2017). The level of reactive oxygen species, which is thought to be one of the key mediators of antimicrobial innate immunity defense in the insect gut (Molina-Cruz et al., 2008), was also reduced in body lice compared to head lice (Kim et al., 2017). Moreover, the role of endosymbiotic bacteria in the modulation of the host immune responses to pathogenic infections should be investigated (Kim et al., 2017). The impact of endosymbionts to insect antibacterial immune responses was already described in several insects (Eleftherianos et al., 2013). For example, the flies carrying the Spiroplasma endosymbiont have been shown to be more susceptible to septic injury with some Gram-negative bacteria, compared to flies lacking the endosymbiont. These results suggest that Spiroplasma endosymbionts are able to confer antibacterial immunity against certain bacterial pathogens in flies (Herren and Lemaitre, 2011).

Moreover, the fact that body and head lice have distinct ecological niches and have distinctly different feeding patterns, are additional factors that might influence the transmission of pathogens by lice. Body lice live in clothing where they must face the movements of the host’s body to access blood, so they are under increased stress compared to head lice (Raoult and Roux, 1999; Veracx and Raoult, 2012). The effects of stress on immunity are well-known in insect vectors (Muturi et al., 2011) and may cause alterations that may lead to the reduced innate immune response observed in body lice against pathogenic bacteria. Similarly, the body lice are known to ingest large blood meal as compared to head lice (Brouqui, 2011; Veracx and Raoult, 2012). Absorption of larger meals of infectious blood may result in more bacteria entering the louse midgut, and therefore, a possible increase in infection.

Under laboratory conditions, head lice can also transmit R. prowazekii. The first evidence was reported by Goldberger and Anderson, who have successfully transmitted typhus to naïve rhesus macaques by subcutaneous inoculation of infected crushed head lice, recovered from patients with epidemic typhus (Goldberger and Anderson, 1912). Subsequently, this finding was confirmed by Murray and Torrey (1975) who showed that head lice feeding on rabbits infected with R. prowazekii can be easily infected and spread virulent organisms in their feces, thus demonstrating that head lice have the potential to transmit pathogenic bacteria when placed under favorable epidemiological conditions (Murray and Torrey, 1975). In addition, it has been proposed that this louse could also be implicated in the transmission and maintenance of this pathogen in the nature (Robinson et al., 2003).

In recent years, several pathogenic bacteria DNA have been increasingly reported in head lice in many parts of the world (Figure 2). Detailed results on the epidemiological studies are reported in Table 1. For instance, B. quintana was the most frequently found in head lice belonging to clades A, D, E, and C. Furthermore, it is important to underline that, except one reported case of its detection in lice collected from school children (Eremeeva et al., 2017), all other cases occurred on lice infesting deprived populations living in poverty and lacking standard medications (Table 1). An interesting study of head lice collected from the rural population of Senegal, where several cases of trench fever have occurred, showed that several head lice were positive for B. quintana. These findings, together with the absence of body lice from this area for more than 30 years, strongly implicate head lice as the principal acting in maintaining the cycle of transmission of B. quintana among the population concerned (Diatta et al., 2014).

TABLE 1 | Bacteria species fou nd i n head l ice usi ng molecu lar methods .   

<html><body><table><tr><td>Pathogen</td><td>Lice tested (% positive)</td><td>Louse-clade</td><td>Collection year</td><td>Population</td><td>Country</td><td>Co-occurrence of body louse</td><td>Comment</td><td>References</td></tr><tr><td>B. quintana</td><td>21 (9.5%)</td><td></td><td>2002</td><td>Homeless and school children</td><td>Nepal</td><td>Yes</td><td>All lice collected from school children were B. quintana</td><td>Sasaki et al., 2006</td></tr><tr><td></td><td>15 pools (20%)</td><td></td><td>2007-2008</td><td>Homeless persons</td><td>California-USA</td><td>Not all</td><td>negatives</td><td>Bonilla et al., 2009</td></tr><tr><td></td><td>16 pools (37.5%)</td><td></td><td>2008-2010, 2012</td><td>Homeless persons</td><td>California-USA</td><td>Not al</td><td></td><td>Bonilla et al., 2014</td></tr><tr><td></td><td>3 pools nits (100%)</td><td></td><td></td><td>Homeless persons</td><td>France</td><td>No</td><td>Attempt to cultivate B. quintana from these nits was failed</td><td>Angelakis et al., 2011b</td></tr><tr><td></td><td>35 (17.1%)</td><td>Aand D</td><td>2010</td><td>Persons iving in a highly</td><td>Congo RDC</td><td>Yes</td><td></td><td>Piarroux et al.,2013; Drali et al.,</td></tr><tr><td></td><td>35 (2.85%)</td><td></td><td>2011</td><td>plague-endemic area Patients with</td><td>Ethiopia</td><td>Yes</td><td></td><td>2015b Boutellis et al., 2013b</td></tr><tr><td></td><td>65 pools</td><td></td><td>2010</td><td>louse-borne relapsing fever Street beggars (in poorer</td><td>Ethiopia</td><td>1</td><td>More pools of head lice were</td><td>Cutler et al., 2012</td></tr><tr><td></td><td>(9.2%) 271 (7%)</td><td>C</td><td></td><td>regions) Persons living at locations at different altitudes</td><td>Ethiopia</td><td>Not all</td><td>found positive than body lice B. quintana in head lice was positively linked to altitude (&gt;2,121m).Atthisatitude all</td><td>Angelakis et al., 2011a</td></tr><tr><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td>body lice were B. quintana negatives</td><td></td></tr><tr><td></td><td>381 (0.52)</td><td>274 (6.93%)Aand E</td><td>2010-2011</td><td>Persons living in poor conditions Rural community</td><td>Senegal</td><td>No</td><td></td><td>Sangaré et al., 2014</td></tr><tr><td></td><td>148 (1.3%)</td><td>A A</td><td>2011 2011</td><td>Rural villagers living in poor conditions</td><td>Senegal Senegal</td><td>No</td><td>Co-occurrence of trench fever cases with absence of body lice</td><td>Diatta et al., 2014</td></tr><tr><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td>for more than 30 years in the studied area</td><td></td></tr><tr><td></td><td>600 (0.5%)</td><td></td><td>2013</td><td>income Rral vilagers living in poor</td><td>Mali</td><td>No</td><td>Apparently healthy individuals,</td><td>Amanzougaghene et al.,2017</td></tr><tr><td></td><td>168 (10.3%)</td><td></td><td>2013-2015</td><td>conditions School children</td><td>Georgia-USA</td><td>No</td><td>low socioeconomic level The kdr-permethrin resistance (T917l mutation) was detected in</td><td>Eremeeva et al.,2017</td></tr><tr><td>B. recurrentis</td><td>35 (22.8%)</td><td></td><td></td><td>Patients with louse-borne</td><td>Ethiopia</td><td></td><td>99.9% of 168 lice tested 4 of 5 patients were co-infested</td><td></td></tr><tr><td></td><td>630 (1.6%)</td><td>A</td><td>2015</td><td>relapsing fever Pygmy populations,living in</td><td>Republic of Congo</td><td>Not all</td><td>with body louse</td><td>Amanzougaghene et al., 2016a</td></tr><tr><td>Y. pestis</td><td>35 (2.86%)</td><td>A</td><td>2010</td><td>poor conditions Personsliving in a hghly</td><td>Congo RDC</td><td>Yes</td><td></td><td>Piarroux et al.,2013; Draliet al,</td></tr></table></body></html>

TABLE 1 | Conti n ued   

<html><body><table><tr><td>Pathogen</td><td>Lice tested (% positive)</td><td>Louse-clade</td><td>Collection year</td><td>Population</td><td>Country</td><td>Co-occurrence of body louse</td><td>Comment</td><td>References</td></tr><tr><td>B. theileri</td><td>630 (0.16%)A</td><td></td><td>2015</td><td>Pygmy populations,living in poor conditions</td><td>Republic of Congo</td><td>No</td><td></td><td>Amanzougaghene et al., 2016a</td></tr><tr><td>C. burmeti</td><td>600 (1.16%)</td><td></td><td>2013</td><td>Ruralvillagers living in poor conditions</td><td>Mali</td><td>No</td><td>MST genotype 35 and new genotype (genotype 59)</td><td>Amanzougaghene et al.,2017</td></tr><tr><td></td><td>37 (8.10%)</td><td></td><td>2016</td><td>Niger&#x27;s refugees arriving in Algeria, living in poor</td><td>Algeria</td><td>No</td><td></td><td>Louni et al., 2018</td></tr><tr><td>R.aeschlimannii</td><td>600 (0.6%)</td><td>E</td><td>2013</td><td>conditions Ruralvllagers living in poor conditions</td><td>Mali</td><td>No</td><td>Apparently healthy individuals, low socioeconomic level</td><td>Amanzougaghene et al.,2017</td></tr><tr><td>Anaplasma</td><td>600 (0.3%)</td><td>E</td><td>2013</td><td>Ruralvllagers living in poor conditions</td><td>Mali</td><td>No</td><td>Potential new species</td><td>Amanzougaghene et al.,，2017</td></tr><tr><td>Ehrlichia</td><td>600 (2.3%)</td><td>E</td><td>2013</td><td>Ruralvllagers living in poor</td><td>Mali</td><td>No</td><td>E.aff. mineirensis and potential</td><td>Amanzougaghene et al., 2017</td></tr><tr><td>Acinetobacter</td><td>288 (33%)</td><td></td><td>2008-2009</td><td>conditions School children</td><td>France</td><td>1</td><td>new species 1</td><td>Bouvresse et al., 2011</td></tr><tr><td></td><td>115 (47%)</td><td>A and C</td><td>1</td><td>Healthy individuals</td><td>Ethiopia</td><td>Yes</td><td>13 of 23 ice sequenced were A. baumannii</td><td>Kempf et al.,2012</td></tr><tr><td></td><td>275 (3.62%)</td><td>A and C</td><td>2013-2014</td><td>School children</td><td>Thailand</td><td>No</td><td>Species: A. baumanni,A. radioresistens,and A. schindleri</td><td>Sunantaraporn et al., 2015</td></tr><tr><td></td><td>630 (31.1%)</td><td>A, C,and D</td><td>2015</td><td>Pygmy populations,living in poor conditions</td><td>Republic of Congo</td><td>No</td><td>Species: A. juni, A. ursingi, A. baumanni,A. johnsonii, A.</td><td>Amanzougaghene et al., 2016a</td></tr><tr><td></td><td>52 (80.8%)</td><td></td><td>2013-2015</td><td>School children</td><td>Georgia-USA</td><td>No</td><td>schindleri, A. woffi,A. nosocomialis,and A. towneri</td><td>Eremeeva et al., 2017</td></tr><tr><td></td><td></td><td>235 (11.5%)A,B,and E</td><td>2015-2016</td><td>Middle-class suburban familiesFrance</td><td></td><td>No</td><td>A.baumannii,A.calcoaceticus, A. nosocomialis,A. junii,and 2 potential new species (Candidatus Acinetobacter</td><td>Candy et al.,2018a</td></tr><tr><td></td><td>64 (27%)</td><td>A and B</td><td>2014</td><td>School children</td><td>Algeria</td><td>No</td><td>Bobigny-1 and 2) A.baumannii,A. johnsonii, and A. variabilis</td><td>Mana et al., 2017</td></tr><tr><td></td><td>37 (46.94%)E</td><td></td><td>2016</td><td>Niger&#x27;s refugees arriving in Algeria</td><td>Algeria</td><td>No</td><td>A.baumannii</td><td>Louni et al., 2018</td></tr><tr><td>Moraxellaceae</td><td>630 (0.95%)A</td><td></td><td>2015</td><td>Pygmy populations,living in poor conditions</td><td>Republic of CongoNo</td><td></td><td>New species</td><td>Amanzougaghene et al.,，2016a</td></tr></table></body></html>

The DNA of this bacterium was also recovered in head louse nits from homeless individuals in Marseille. This funding strongly support a possible vertical transmission of this pathogen in lice (Angelakis et al., 2011b). A study performed on lice from persons at various locations in Ethiopia revealed that head lice infection by B. quintana was linked to high altitude (Angelakis et al., 2011a). Interestingly, the head lice collected from persons living at higher altitudes $( > 2 , 1 2 1 \mathrm { m } )$ were B. quintana positive $2 4 \%$ of 79), while at these altitudes, none of the 63 tested body lice were found to be infected with B. quintana (Angelakis et al., 2011a). This finding raises important question about the possible relationship of the head lice vectorial capacity and environmental-ecological factors that may drive force underpinning the transmission potential in some geographic areas.

Borrelia recurrentis was detected in clade C head lice from patients suffering with louse-borne relapsing fever living in poor regions from Ethiopia, and more recently in head lice clade A from hunter-gatherer pygmy individuals in the Republic of the Congo (Boutellis et al., 2013b; Amanzougaghene et al., 2016a). The Y. pestis DNA was also found in clade A head lice infesting individuals from a highly endemic plague area in the eastern Congo (Piarroux et al., 2013; Drali et al., 2015b). Other human pathogenic bacteria, which are not usually associated with lice transmission, such as C. burnetii, R. aeschlimannii, and potential new species from the Anaplasma and Ehrlichia genera were also detected in head lice (Amanzougaghene et al., 2017). Moreover, the DNA of Ixodid hard tick-associated B. theileri, which is not known to infect humans, was also detected in one head louse infesting an African pygmy from the Republic of Congo (Amanzougaghene et al., 2016a). As head lice feed only on human blood, the authors suggested that the acquired louse infection would be from the blood of patients with ongoing bacteremia (Amanzougaghene et al., 2016a). However, whether this spirochete is able to infect human is currently not known and requires further investigation.

Head louse infection with all of the above pathogenic bacteria most likely occurs among the most vulnerable and poor populations living in poverty and poor hygiene, the same conditions that usually lead to the proliferation of body louse ecotype and the emergence of louse-borne diseases (Raoult and Roux, 1999; Brouqui, 2011). This point of view is also supported by the fact that most studies on head lice infesting schoolchildren and populations living in more hygienic conditions have failed to detect these pathogenic bacteria (Fournier et al., 2002; Bouvresse et al., 2011; Sunantaraporn et al., 2015; Candy et al., 2018a).

However, head lice infection with Acinetobacter is an exception, as several species have been detected with high prevalence in head lice, as well as in body lice everywhere they have been sought, reflecting the ubiquitous occurrence of these bacterial species (Bouvresse et al., 2011; Sunantaraporn et al., 2015; Amanzougaghene et al., 2016a; Candy et al., 2018a). This widespread infection of human lice suggests that they could be a preferential host for these bacteria. Nevertheless, it remains to be determined whether these strains of Acinetobacter found in lice are the same as those causing infections in humans (Amanzougaghene et al., 2016a; Candy et al., 2018a). In addition, the susceptibility of these isolates to antibiotics is currently unknown. In one study, Vallenet et al. (2008) showed that phenotypic and genotypic characteristics of the human multidrug resistant isolate A. baumannii AYE significantly differ from the SDF strain isolated from body lice (Vallenet et al., 2008). Further studies are warranted to compare both phenotypic and genotypic characteristics, as well as antimicrobial susceptibility of louse derived Acinetobacter isolates. Greater attention is given to extra-hospital reservoirs of these opportunistic bacteria and their potential involvement in emerging human community-acquired infections, as drug-resistant strains worldwide are increasingly being identified (Eveillard et al., 2013).

Based on the combined evidence of both epidemiological and laboratory studies, we believe that head lice can transmit disease to their human host under favorable epidemiological conditions, although its vectorial capacity is weaker compared to body lice. Therefore, given the scale of head louse infestations around the world and the emergence and spread of insecticides resistance, this pest is warranting more attention as a serious public health problem. For instance, epidemiological studies on louse specimens collected worldwide to investigate the diversity of pathogenic bacteria associated with head lice, but also for body lice, are missing. Regarding experimental models, the vectorial competence of lice should be investigated for pathogenic bacteria, such as C. burnetii, and other pathogenic bacteria, which are not usually associated with lice.

# CONTROL OF LICE INFESTATIONS AND EVOLUTION OF INSECTICIDE RESISTANCE

# Therapeutic Options for Pediculosis Treatment

There are many therapeutic options for pediculosis, including chemical insecticides, topically applied physical agents (Table 2), herbal formulations and mechanical methods (combs and heating devices) (Bonilla et al., 2013; Feldmeier, 2014; Sangaré et al., 2016a). However, the recourse to chemical insecticides with an insect neurotoxic mode of action is still the method of choice and the most extensively used approach (Durand et al., 2012; Clark et al., 2013). These include organochloride (lindane), organophosphates (malathion), carbamates (carbaryl), pyrethrins (extract of chrysanthemum), and pyrethroids (synthetic derivates of pyrethrins: permethrin, phenothrin, and deltamethrin) (Table 2) (Durand et al., 2012; Bonilla et al., 2013; Clark et al., 2013). Among them, malathion and permethrin remain the most widely used pediculicides since their introduction on the market in 1971 and 1992, respectively (Durand et al., 2012; Clark et al., 2013).

Unfortunately, the wider use of conventional pediculicides has resulted in the emergence and rapid propagation of resistant lice populations in many regions of the world (Durand et al., 2012; Clark et al., 2013). This has prompted research into the development of compounds with other modes of action. Ivermectin and spinosad seem to be the most hopeful new pediculicides. They have generated interest in their new neurotoxic modes of action; have low mammalian toxicity and relatively low cross-resistance with commonly used conventional pediculicides (Chosidow et al., 2010; Aditya and Rattan, 2012; Bonilla et al., 2013; Clark et al., 2015). In addition, ivermectin is the only drug currently used for oral treatment, and its highly effectiveness was clinically approved for both louse ecotypes treatment (Foucault et al., 2006; Chosidow et al., 2010), although empirically noted ivermectin resistance has started to be reported in the field in Senegal (Diatta et al., 2016).

TABLE 2 | Main Therapeutic options for pediculosis treatment.   

<html><body><table><tr><td>Pediculicide</td><td>Class</td><td>Mechanism of action</td><td>Adulticide/ovicidal Documented Documented References activities</td><td>adverse health effect lice</td><td>resistance in</td><td></td></tr><tr><td colspan="7">PEDICULICIDE WITH A NEUROTOXIC MODE OF ACTION</td></tr><tr><td>DDT,</td><td>Organochloride</td><td>Opening of sodium ion channels in neurons</td><td>Yes/yes</td><td>Toxic</td><td>Yes</td><td>Durand et al., 2012; Bonilla et al., 2013</td></tr><tr><td>dichlorodiphenyItrichloroethane Lindane</td><td>Organochloride</td><td>InhibitionofC-aminobutyricYes/yes</td><td></td><td>Toxic</td><td>Yes</td><td>Durand et al., 2012;</td></tr><tr><td>Natural pyrethrins</td><td></td><td>acid- gated chloride channel Chrysanthemum extract Delayed repolarization of</td><td>Yes/no</td><td>Minor</td><td>Yes</td><td>Bonilla et a., 2013 Bonilla et al., 2013</td></tr><tr><td>Permethrin,synthetic pyrethrin</td><td>(+)-3-phenoxybenzyl 3-(2,2-dichlorovinyl-2,2，pyeth</td><td>voltage-gated The same as natural</td><td>Yes/no</td><td>Minor</td><td>Yes</td><td>Durand et al., 2012; Bonilla et al.,2013;</td></tr><tr><td>Malathion</td><td>dimethyl cyclopropan carboxylate Organophosphate</td><td></td><td></td><td>Minor</td><td></td><td>Clark et al., 2013 Durand et al., 2012;</td></tr><tr><td></td><td></td><td>acetylcholinesterase Irreversible inhibition of</td><td></td><td></td><td></td><td>Bonilla et al., 2013; Kwon et al.,2014</td></tr><tr><td>Carbaryl</td><td>Carbamate</td><td>acetylcholinesterase</td><td>Yes/no</td><td>Moderate to very toxic</td><td>Yes</td><td>Durand et al.,2012; Bonilla et al., 2013 Chosidow et al., 2010;</td></tr><tr><td>Ivermectin*</td><td>Macrocyclic lactone</td><td>Binding to glutamate-gatedYes/no chloride ion channels</td><td></td><td>None to minimal</td><td>Yes</td><td>Clark et al., 2013; Diatta et al., 2016</td></tr><tr><td>Spinosad</td><td>Macrocyclic lactone</td><td>Overstimulates nerve cels by Yes/yes acting like acetylcholine</td><td></td><td>Minor</td><td>No</td><td>Aditya and Rattan, 2012; Feldmeier,2014</td></tr><tr><td colspan="7">PEDICULICIDE WITH PHYSICAL MODE OF ACTION</td></tr><tr><td>Dimeticone</td><td> Synthetic silicone oils</td><td>Work by occlusion</td><td>Yes/yes</td><td>Low</td><td>No</td><td>Durand et al., 2012; Burgess et al., 2013;</td></tr><tr><td>Isopropyl myristate</td><td>Ester</td><td>Work by occlusion or by dissolving cuticle wax</td><td>Only head lice tested Minimal</td><td></td><td>No</td><td>Feldmeier,2014 Feldmeier,2014</td></tr><tr><td>1,2-octanediol</td><td>Detergent</td><td>Dehydration by reducing the Yes/no ability of louse to prevent</td><td></td><td>Minimal</td><td>No</td><td>Burgess et al., 2012; Feldmeier, 2014;</td></tr><tr><td></td><td></td><td>water loss through the cuticle</td><td></td><td></td><td></td><td>Burgess and Silverston, 2015</td></tr><tr><td>Benzyl alcohol</td><td>Aromatic alcohol</td><td>Asphyxiates lice by “stunning&quot; the spiracles open</td><td>Yes/no</td><td>Minimal</td><td>No</td><td>Meinking et al.,2010</td></tr></table></body></html>

\*Ivermectin is the only pediculicide used on topical and oral administrations whereas the other pediculicides are only available through topical applications.

There is also growing interest in the use of natural products such as pediculicides based on plant-derived essential oils (eucalyptus oil and tea tree oil) or with a purely physical mode of action, such as dimeticone and benzyl alcohol (Meinking et al., 2010; Burgess et al., 2013; Candy et al., 2018b), but little attention has been given to their clinical evaluation for effectiveness, even though some of them are already commercialized.

# Insecticide Resistance

Insecticide resistance leading to treatment failure is considered a crucial factor in the increasing incidence of head lice infestations (Durand et al., 2012; Bonilla et al., 2013). Resistance is an established trait that an insect pest acquires over time through selective pressure from continuous or inappropriate insecticide use (Durand et al., 2012). The recently sequenced body louse genome provides a unique opportunity to address fundamental issues related to the molecular mechanisms that determine the insecticides resistances, which is fundamental to ensure the longest possible active lifespan of existing insecticides and to accelerate the achievement of sustainable, new, and effective strategies to control pest infestations (Kirkness et al., 2010; Clark et al., 2015).

Possible resistance mechanisms include knockdownresistance in the case of permethrin, which is the result of three-point mutations (M815I, T917I, and L920) within the α- subunit gene of the voltage-gated sodium channel, and enhanced activity of a carboxylesterase enzyme was found to be chiefly responsible for the resistance to malathion (Clark, 2009; Kwon et al., 2014). Recently, a researcher from our team documented the first field resistance to ivermectin observed in head lice recovered in rural populations from Senegal (Diatta et al., 2016).

Genetic analysis of these lice by targeting GluCl gene, which is the primary target-site of ivermectin and already known to be implicated in resistance of arthropods and nematodes, revealed the presence of three relevant non-synonymous mutations (A251V, H272R, and S46P) that may be responsible for the treatment failure (Amanzougaghene et al., 2018a).

In addition, in another study, a proteomic comparison of laboratory-sensitive lice (wild type) and ivermectin-selected resistant lice found that a complexin was most significatively suppressed in resistant lice. A complexin is a neuronal protein that is known to be one of the main regulators of neurotransmitter release. DNA-mutation analysis revealed that some complexin transcripts from resistant lice gained a premature stop codon. The association between complexin and ivermectin-resistance was further confirmed by RNA-interfering and found that the knocking down complexin expression induces resistance to ivermectin in the susceptible lice. All together, these results provide a convincing evidence that complexin plays a significant role in regulating ivermectin resistance in the body louse and represents the first evidence that links complexin to insecticide resistance (Amanzougaghene et al., 2018b). Although, how this resistance effect is mediated requires further elucidation.

# New Therapeutic Approaches Symbiotic Therapy

This approach incited great interest for potential applications in public health entomology (Sassera et al., 2013) and has the advantage to target the bacteria susceptible to antibiotics (Sassera et al., 2013). Since the Pediculus lice’ primary endosymbiont, Candidatus Riesia pediculicola, is essential to the metabolism of their louse host, related to its ability of synthesizing B-group vitamins, the harmful effect exerted by the antibiotic treatment should have repercussions on the host (Kirkness et al., 2010; Sangaré et al., 2016a). A first case report showed that antibiotic treatment (trimethoprim and sulfamethoxazole), administered to treat a respiratory infection in a 12-year-old girl, had the side effect of head lice death (Shashindran et al., 1978). Subsequently, studies conducted by Sangaré et al. (2015) demonstrated the effectiveness of this therapy under laboratory conditions and showed that antibiotics (such as doxycycline, erythromycin, rifampicin, and azithromycin) kill lice via their direct activity on their symbiotic bacteria. In addition, the combination of this antibiotic with ivermectin has proven to be very effective compared to ivermectin alone in the treatment and prevention of body lice (Sangaré et al., 2016b). This approach could be employed to eradicate lice and could potentially retard the apparition of resistance to ivermectin (Sangaré et al., 2016b). This approach is a promising therapy but has not yet been the subject of field studies.

# RNAi-Based Insecticides

RNA interference (RNAi) is a promising and safe environmentally friendly method for insect control (Das et al., 2015). This technology is initiated by the presence of a small interfering RNA (siRNA) or double-stranded RNA (dsRNA) to trigger post-transcriptional gene silencing (Das et al., 2015). RNAi can induce mortality, create phenotypes that are beneficial for insect control and prevent insecticide resistance in insect pests (Gordon and Waterhouse, 2007; Airs and Bartholomay, 2017). Currently, the greater potential of this technology for successful future management of pest insects is widely recognized and holds great promise (Baum et al., 2007; Airs and Bartholomay, 2017). Therefore, it is exciting to consider its role in lice control as a promising alternative to chemical insecticides, to specifically to suppress the expression of essential genes that lead to death (Scott et al., 2013). Two lines of evidence support its potential use as control strategy in lice. First, the analysis of body louse genome has been shown to contain the necessary genes for RNAi machinery (Pittendrigh et al., 2013). Subsequently, the studies conducted on both body and head lice confirmed that the injection of dsRNA to these two ecotypes can efficiently repress the expression of target genes (Yoon et al., 2011; Kwon et al., 2014). A second beneficial of using this technology in Pediculus lice is the lack of gene redundancy in its small genome. Thus, a smaller set of genes can be investigated to identify which one is essential for a given biological process (Pittendrigh et al., 2013). A priority for the future should focus on the identification of effective target genes for RNAi and, subsequently, on the exploration of delivery methods using field-proven applications (Pittendrigh et al., 2013). Finally, although technically realizable, it remains to be defined whether such strategies could comply with the requirements of regulatory authorities and whether an economically attractive strategy can be implemented to use RNAi approach to fight against lice (Pittendrigh et al., 2013).

# CONCLUDING REMARKS AND FUTURE PERSPECTIVES

In the twenty-first century, human lice infestation remains widespread all over the world. Surprising new discoveries into the biology, epidemiology, and the evolutionary history of lice, their bacterial disease agents and control strategies have further stimulated a renewal of interest in this bloodsucking insect. In recent years, knowledge about lice has evolved, with the sequencing of the body lice genome and the development of transcriptomes of body and head lice. However, functional and comparative genomics of the fundamental aspects of lice biology is still in its infancy and many aspects are not yet well-understood and remain to be discovered.

Additional efforts will be necessary to shed the light on lice biology. Whole genome sequencing of head lice belonging to different clades with integration of high-throughput technologies to study global changes in mRNA transcription, translation and computational approaches, will accelerate the addressing of important biological questions, identification, and exploitation of new target genes of this insect vector, insecticide discovery, as well as to develop novel therapies. Although our knowledge of the vector competence of head lice is increasing, there is still a need to explore factors that can influence the difference observed between body and head lice, such as the influence of the immune response and microbiota (especially the role of endosymbiotic bacteria). Such factors, once addressed, will provide us with a better understanding of effective lice control and prevention strategies for re-emerging diseases. Finally, because P. humanus is one of the oldest parasites of human which carries a written record of our past in its DNA, integrating phylogenomic and genomic population patterns in lice will provide a more complete picture of the evolution of this parasite and clarify additional events in our evolutionary history.

# AUTHOR CONTRIBUTIONS

NA, OM, FF, and DR conceived the paper. NA wrote the paper.

# FUNDING

This work was supported by the Fondation Méditerranée Infection and the French National Research Agency under the Investissements d’avenir program, reference ANR-10-IAHU-03.

# REFERENCES

Aditya, S., and Rattan, A. (2012). Spinosad: an effective and safe pediculicide. Indian Dermatol. Online J. 3, 213–214. doi: 10.4103/2229-5178. 101825   
Airs, P. M., and Bartholomay, L. C. (2017). RNA interference for mosquito and mosquito-borne disease control. Insects 8:E4. doi: 10.3390/insects8010004   
Alpatov, V., and Nastukova, O. (1955). Transformation of the head form of Pediculus humanus into the body form under changed conditions of existence. Bull Mosc. Nat Hist Res Soc. 60, 79–92.   
Al-Shahrani, S. A., Alajmi, R. A., Ayaad, T. H., Al-Shahrani, M. A., and Shaurub, E.-S. H. (2017). Genetic diversity of the human head lice, Pediculus humanus capitis, among primary school girls in Saudi Arabia, with reference to their prevalence. Parasitol. Res. 116, 2637–2643. doi: 10.1007/s00436-017-5570-3   
Amanzougaghene, N., Akiana, J., Mongo Ndombe, G., Davoust, B., Nsana, N. S., Parra, H.-J., et al. (2016a). Head lice of pygmies reveal the presence of relapsing fever borreliae in the Republic of Congo. PLoS Negl. Trop. Dis. 10:e0005142. doi: 10.1371/journal.pntd.0005142   
Amanzougaghene, N., Fenollar, F., Davoust, B., Djossou, F., Ashfaq, M., Bitam, I., et al. (2019). Mitochondrial diversity and phylogeographic analysis of Pediculus humanus reveals a new Amazonian clade “F.” Infect. Genet. Evol. 70, 1–8. doi: 10.1016/j.meegid.2019.02.006   
Amanzougaghene, N., Fenollar, F., Diatta, G., Sokhna, C., Raoult, D., and Mediannikov, O. (2018a). Mutations in GluCl associated with field ivermectinresistant head lice from Senegal. Int. J. Antimicrob. Agents. 52, 593–598. doi: 10.1016/j.ijantimicag.2018.07.005   
Amanzougaghene, N., Fenollar, F., Nappez, C., Ben-Amara, A., Decloquement, P., Azza, S., et al. (2018b). Complexin in ivermectin resistance in body lice. PLoS Genet. 14:e1007569. doi: 10.1371/journal.pgen.1007569   
Amanzougaghene, N., Fenollar, F., Sangaré, A. K., Sissoko, M. S., Doumbo, O. K., Raoult, D., et al. (2017). Detection of bacterial pathogens including potential new species in human head lice from Mali. PLoS ONE 12:e0184621. doi: 10.1371/journal.pone.0184621   
Amanzougaghene, N., Mumcuoglu, K. Y., Fenollar, F., Alfi, S., Yesilyurt, G., Raoult, D., et al. (2016b). High ancient genetic diversity of human lice, Pediculus humanus, from Israel reveals new insights into the origin of clade B lice. PLoS ONE 11:e0164659. doi: 10.1371/journal.pone.0164659   
Angelakis, E., Diatta, G., Abdissa, A., Trape, J.-F., Mediannikov, O., Richet, H., et al. (2011a). Altitude-dependent Bartonella quintana genotype C in head lice, Ethiopia. Emerg. Infect. Dis. 17, 2357–2359. doi: 10.3201/eid1712.110453   
Angelakis, E., Rolain, J.-M., Raoult, D., and Brouqui, P. (2011b). Bartonella quintana in head louse nits. FEMS Immunol. Med. Microbiol. 62, 244–246. doi: 10.1111/j.1574-695X.2011.00804.x   
Antinori, S., Mediannikov, O., Corbellino, M., Grande, R., Parravicini, C., Bestetti, G., et al. (2016a). Louse-borne relapsing fever (Borrelia recurrentis) in a Somali refugee arriving in Italy: a re-emerging Infection in Europe? PLoS Negl. Trop. Dis. 10:e0004522. doi: 10.1371/journal.pntd.0004522   
Antinori, S., Mediannikov, O., Corbellino, M., and Raoult, D. (2016b). Louseborne relapsing fever among East African refugees in Europe. Travel Med. Infect. Dis. 14, 110–114. doi: 10.1016/j.tmaid.2016.01.004   
Araújo, A., Ferreira, L. F., Guidon, N., Maues da Serra Freire, N., Reinhard, K. J., and Dittmar, K. (2000). Ten thousand years of head lice infection. Parasitol. Today 16:269. doi: 10.1016/S0169-4758(00)01694-X   
Ascunce, M. S., Fane, J., Kassu, G., Toloza, A. C., Picollo, M. I., González-Oliver, A., et al. (2013). Mitochondrial diversity in human head louse populations across the Americas. Am. J. Phys. Anthropol. 152, 118–129. doi: 10.1002/ajpa.22336   
Ashfaq, M., Prosser, S., Nasir, S., Masood, M., Ratnasingham, S., and Hebert, P. D. N. (2015). High diversity and rapid diversification in the head louse, Pediculus humanus (Pediculidae: Phthiraptera). Sci. Rep. 5:14188. doi: 10.1038/srep14188   
Babudieri, B. (1959). Q fever: a zoonosis. Adv. Vet. Sci. 5, 82–182.   
Baum, J. A., Bogaert, T., Clinton, W., Heck, G. R., Feldmann, P., Ilagan, O., et al. (2007). Control of coleopteran insect pests through RNA interference. Nat. Biotechnol. 25, 1322–1326. doi: 10.1038/nbt1359   
Bechah, Y., Capo, C., Mege, J.-L., and Raoult, D. (2008). Epidemic typhus. Lancet Infect. Dis. 8, 417–426. doi: 10.1016/S1473-3099(08)70150-6   
Bonilla, D. L., Cole-Porse, C., Kjemtrup, A., Osikowicz, L., and Kosoy, M. (2014). Risk factors for human lice and bartonellosis among the homeless, San Francisco, California, USA. Emerg. Infect. Dis. 20, 1645–1651. doi: 10.3201/eid2010.131655   
Bonilla, D. L., Durden, L. A., Eremeeva, M. E., and Dasch, G. A. (2013). The biology and taxonomy of head and body lice–implications for louse-borne disease prevention. PLoS Pathog. 9:e1003724. doi: 10.1371/journal.ppat.1003724   
Bonilla, D. L., Kabeya, H., Henn, J., Kramer, V. L., and Kosoy, M. Y. (2009). Bartonella quintana in body lice and head lice from homeless persons, San Francisco, California, USA. Emerg. Infect. Dis. 15, 912–915. doi: 10.3201/eid1506.090054   
Boutellis, A., Abi-Rached, L., and Raoult, D. (2014). The origin and distribution of human lice in the world. Infect. Genet. Evol. 23, 209–217. doi: 10.1016/j.meegid.2014.01.017   
Boutellis, A., Bitam, I., Fekir, K., Mana, N., and Raoult, D. (2015). Evidence that clade A and clade B head lice live in sympatry and recombine in Algeria. Med. Vet. Entomol. 29, 94–98. doi: 10.1111/mve.12058   
Boutellis, A., Drali, R., Rivera, M. A., Mumcuoglu, K. Y., and Raoult, D. (2013a). Evidence of sympatry of clade a and clade B head lice in a pre-Columbian Chilean mummy from Camarones. PLoS ONE 8:e76818. doi: 10.1371/journal.pone.0076818   
Boutellis, A., Mediannikov, O., Bilcha, K. D., Ali, J., Campelo, D., Barker, S. C., et al. (2013b). Borrelia recurrentis in head lice, Ethiopia. Emerg. Infect. Dis. 19, 796–798. doi: 10.3201/eid1905.121480   
Boutellis, A., Veracx, A., Angelakis, E., Diatta, G., Mediannikov, O., Trape, J.- F., et al. (2012). Bartonella quintana in head lice from Sénégal. Vector Borne Zoonotic Dis. 12, 564–567. doi: 10.1089/vbz.2011.0845   
Bouvresse, S., Socolovshi, C., Berdjane, Z., Durand, R., Izri, A., Raoult, D., et al. (2011). No evidence of Bartonella quintana but detection of Acinetobacter baumannii in head lice from elementary schoolchildren in Paris. Comp. Immunol. Microbiol. Infect. Dis. 34, 475–477. doi: 10.1016/j.cimid.2011.08.007   
Boyd, B. M., Allen, J. M., Nguyen, N.-P., Vachaspati, P., Quicksall, Z. S., Warnow, T., et al. (2017). Primates, lice and bacteria: speciation and genome evolution in the symbionts of hominid lice. Mol. Biol. Evol. 34, 1743–1757. doi: 10.1093/molbev/msx117   
Boyd, B. M., and Reed, D. L. (2012). Taxonomy of lice and their endosymbiotic bacteria in the post-genomic era. Clin. Microbiol. Infect. 18, 324–331. doi: 10.1111/j.1469-0691.2012.03782.x   
Brouqui, P. (2011). Arthropod-borne diseases associated with political and social disorder. Annu. Rev. Entomol. 56, 357–374. doi: 10.1146/annurev-ento-120709-144739   
Burgess, I. F., Brunton, E. R., and Burgess, N. A. (2013). Single application of $4 \%$ dimeticone liquid gel versus two applications of $1 \%$ permethrin creme rinse for treatment of head louse infestation: a randomised controlled trial. BMC Dermatol. 13:5. doi: 10.1186/1471-5945-13-5   
Burgess, I. F., Lee, P. N., Kay, K., Jones, R., and Brunton, E. R. (2012). 1,2- Octanediol, a novel surfactant, for treating head louse infestation: identification of activity, formulation, and randomised, controlled trials. PLoS ONE 7:e35419. doi: 10.1371/journal.pone.0035419   
Burgess, I. F., and Silverston, P. (2015). Head lice. BMJ Clin. Evid. 2015:1703.   
Candy, K., Amanzougaghene, N., Izri, A., Brun, S., Durand, R., Louni, M., et al. (2018a). Molecular survey of head and body lice, Pediculus humanus, in France. Vector Borne Zoonotic Dis. 18, 243–251. doi: 10.1089/vbz.20 17.2206   
Candy, K., Nicolas, P., Andriantsoanirina, V., Izri, A., and Durand, R. (2018b). In vitro efficacy of five essential oils against Pediculus humanus capitis. Parasitol. Res. 117, 603–609. doi: 10.1007/s00436-017-5722-5   
Chosidow, O. (2000). Scabies and pediculosis. Lancet 355, 819–826. doi: 10.1016/S0140-6736(99)09458-1   
Chosidow, O., Giraudeau, B., Cottrell, J., Izri, A., Hofmann, R., Mann, S. G., et al. (2010). Oral ivermectin versus malathion lotion for difficult-totreat head lice. N. Engl. J. Med. 362, 896–905. doi: 10.1056/NEJMoa09 05471   
Clark, J. M. (2009). Determination, mechanism and monitoring of knockdown resistance in permethrin-resistant human head lice, Pediculus humanus capitis. J. Asia Pac. Entomol. 12, 1–7. doi: 10.1016/j.aspen.2008.10.007   
Clark, J. M., Yoon, K. S., Kim, J. H., Lee, S. H., and Pittendrigh, B. R. (2015). Utilization of the human louse genome to study insecticide resistance and innate immune response. Pestic. Biochem. Physiol. 120, 125–132. doi: 10.1016/j.pestbp.2014.11.008   
Clark, J. M., Yoon, K. S., Lee, S. H., and Pittendrigh, B. R. (2013). Human lice: past, present and future control. Pestic. Biochem. Physiol. 3, 162–171. doi: 10.1016/j.pestbp.2013.03.008   
Coulaud, P.-J., Lepolard, C., Bechah, Y., Berenger, J.-M., Raoult, D., and Ghigo, E. (2015). Hemocytes from Pediculus humanus humanus are hosts for human bacterial pathogens. Front. Cell. Infect. Microbiol. 4:183. doi: 10.3389/fcimb.2014.00183   
Cutler, S., Abdissa, A., Adamu, H., Tolosa, T., and Gashaw, A. (2012). Bartonella quintana in Ethiopian lice. Comp. Immunol. Microbiol. Infect. Dis. 35, 17–21. doi: 10.1016/j.cimid.2011.09.007   
Das, S., Debnath, N., Cui, Y., Unrine, J., and Palli, S. R. (2015). Chitosan, carbon quantum dot, and silica nanoparticle mediated dsRNA delivery for gene silencing in Aedes aegypti: a comparative analysis. ACS Appl. Mater. Interfaces 7, 19530–19535. doi: 10.1021/acsami.5b05232   
Diatta, G., Abat, C., Sokhna, C., Tissot-Dupont, H., Rolain, J.-M., and Raoult, D. (2016). Head lice probably resistant to ivermectin recovered from two rural girls in Dielmo, a village in Sine-Saloum, Senegal. Int. J. Antimicrob. Agents 47, 501–502. doi: 10.1016/j.ijantimicag.2016.03.013   
Diatta, G., Mediannikov, O., Sokhna, C., Bassene, H., Socolovschi, C., Ratmanov, P., et al. (2014). Prevalence of Bartonella quintana in patients with fever and head lice from rural areas of Sine-Saloum, Senegal. Am. J. Trop. Med. Hyg. 91, 291–293. doi: 10.4269/ajtmh.13-0685   
Drali, R., Abi-Rached, L., Boutellis, A., Djossou, F., Barker, S. C., and Raoult, D. (2016a). Host switching of human lice to new world monkeys in South America. Infect. Genet. Evol. 39, 225–231. doi: 10.1016/j.meegid.2016.02.008   
Drali, R., Boutellis, A., Raoult, D., Rolain, J. M., and Brouqui, P. (2013). Distinguishing body lice from head lice by multiplex real-time PCR analysis of the Phum_PHUM540560 gene. PLoS ONE 8:e58088. doi: 10.1371/journal.pone.0058088   
Drali, R., Mumcuoglu, K., and Raoult, D. (2016b). Human lice in paleoentomology and paleomicrobiology. Microbiol. Spectr. 4:PoH-0005-2014. doi: 10.1128/microbiolspec.PoH-0005-2014   
Drali, R., Mumcuoglu, K. Y., Yesilyurt, G., and Raoult, D. (2015a). Studies of ancient lice reveal unsuspected past migrations of vectors. Am. J. Trop. Med. Hyg. 93, 623–625. doi: 10.4269/ajtmh.14-0552   
Drali, R., Shako, J.-C., Davoust, B., Diatta, G., and Raoult, D. (2015b). A new clade of african body and head lice infected by Bartonella quintana and Yersinia pestis-Democratic Republic of the Congo. Am. J. Trop. Med. Hyg. 93, 990–993. doi: 10.4269/ajtmh.14-0686   
Drancourt, M., Moal, V., Brunet, P., Dussol, B., Berland, Y., and Raoult, D. (1996). Bartonella (Rochalimaea) quintana infection in a seronegative hemodialyzed patient. J. Clin. Microbiol. 34, 1158–1160.   
Durand, R., Bouvresse, S., Berdjane, Z., Izri, A., Chosidow, O., and Clark, J. M. (2012). Insecticide resistance in head lice: clinical, parasitological and genetic aspects. Clin. Microbiol. Infect. 18, 338–344. doi: 10.1111/j.1469-0691.2012.03806.x   
Durden, L. A., and Musser, G. G. (1994). “The sucking lice (Insecta, Anoplura) of the world: a taxonomic checklist with records of mammalian hosts and geographical distributions. Bulletin of the AMNH; no. 218,” in Sucking Lice and Hosts. Available online at: http://digitallibrary.amnh.org/handle/2246/825 (accessed April 15, 2018).   
Eleftherianos, I., Atri, J., Accetta, J., and Castillo, J. (2013). Endosymbiotic bacteria in insects: guardians of the immune system? Front. Physiol. 4:46. doi: 10.3389/fphys.2013.00046   
Eremeeva, M. E., Capps, D., Winful, E. B., Warang, S. S., Braswell, S. E., Tokarevich, N. K., et al. (2017). Molecular markers of pesticide resistance and pathogens in human head lice (Phthiraptera: Pediculidae) from rural Georgia, USA. J. Med. Entomol. 54, 1067–1072. doi: 10.1093/jme/tjx039   
Eveillard, M., Kempf, M., Belmonte, O., Pailhoriès, H., and Joly-Guillou, M.- L. (2013). Reservoirs of Acinetobacter baumannii outside the hospital and potential involvement in emerging human community-acquired infections. Int. J. Infect. Dis. 17, e802–805. doi: 10.1016/j.ijid.2013.03.021   
Feldmeier, H. (2014). Treatment of pediculosis capitis: a critical appraisal of the current literature. Am. J. Clin. Dermatol. 15, 401–412. doi: 10.1007/s40257-014-0094-4   
Foucault, C., Ranque, S., Badiaga, S., Rovery, C., Raoult, D., and Brouqui, P. (2006). Oral ivermectin in the treatment of body lice. J. Infect. Dis. 193, 474–476. doi: 10.1086/499279   
Fournier, P.-E., Ndihokubwayo, J.-B., Guidran, J., Kelly, P. J., and Raoult, D. (2002). Human pathogens in body and head lice. Emerg. Infect. Dis. 8, 1515–1518. doi: 10.3201/eid0812.020111   
Giroud, P., and Jadin, J. (1954). Infection latente et conservation de “Rickettsia burnetii” chez l’homme, le rôle du pou. Bull Soc. Pathol. Exotique 47, 764–765.   
Goldberger, J., and Anderson, J. F. (1912). “The transmission of typhus fever, with especial reference to transmission by the head louse (Pediculus capitis),” in Public Health Report 1896-1970, Vol. 27 (Washington, DC), 297–307.   
Gordon, K. H. J., and Waterhouse, P. M. (2007). RNAi for insect-proof plants. Nat. Biotechnol. 25, 1231–1232. doi: 10.1038/nbt1107-1231   
Hayashi, Y., Lo, N., Miyata, H., and Kitade, O. (2007). Sex-linked genetic influence on caste determination in a termite. Science 318, 985–987. doi: 10.1126/science.1146711   
Herren, J. K., and Lemaitre, B. (2011). Spiroplasma and host immunity: activation of humoral immune responses increases endosymbiont load and susceptibility to certain Gram-negative bacterial pathogens in Drosophila melanogaster. Cell. Microbiol. 13, 1385–1396. doi: 10.1111/j.1462-5822.2011.01627.x   
Houhamdi, L., Fournier, P.-E., Fang, R., and Raoult, D. (2003). An experimental model of human body louse infection with Rickettsia typhi. Ann. N.Y. Acad. Sci. 990, 617–627. doi: 10.1111/j.1749-6632.2003.tb07436.x   
Houhamdi, L., Lepidi, H., Drancourt, M., and Raoult, D. (2006). Experimental model to evaluate the human body louse as a vector of plague. J. Infect. Dis. 194, 1589–1596. doi: 10.1086/508995   
Houhamdi, L., and Raoult, D. (2006a). Experimental infection of human body lice with Acinetobacter baumannii. Am. J. Trop. Med. Hyg. 74, 526–531. doi: 10.4269/ajtmh.2006.74.526   
Houhamdi, L., and Raoult, D. (2006b). Experimentally infected human body lice (Pediculus humanus humanus) as vectors of Rickettsia rickettsii and Rickettsia conorii in a rabbit model. Am. J. Trop. Med. Hyg. 74, 521–525. doi: 10.4269/ajtmh.2006.74.521   
Kalra, S. L., and Rao, K. N. A. (1951). Typhus fevers in kashmir state. Part II. Murine Typhus. Indian J. Med. Res. 39, 297–302.   
Keilin, D., and Nuttall, G. H. F. (1919). Hermaphroditism and other Abnormalities in Pediculus humanus. Parasitology 11, 279–328. doi: 10.1017/S0031182000004285   
Kempf, M., Abdissa, A., Diatta, G., Trape, J.-F., Angelakis, E., Mediannikov, O., et al. (2012). Detection of Acinetobacter baumannii in human head and body lice from Ethiopia and identification of new genotypes. Int. J. Infect. Dis. 16, e680–683. doi: 10.1016/j.ijid.2012.05.1024   
Kim, J. H., Min, J. S., Kang, J. S., Kwon, D. H., Yoon, K. S., Strycharz, J., et al. (2011). Comparison of the humoral and cellular immune responses between body and head lice following bacterial challenge. Insect Biochem. Mol. Biol. 41, 332–339. doi: 10.1016/j.ibmb.2011.01.011   
Kim, J. H., Previte, D. J., Yoon, K. S., Murenzi, E., Koehler, J. E., Pittendrigh, B. R., et al. (2017). Comparison of the proliferation and excretion of Bartonella quintana between body and head lice following oral challenge. Insect Mol. Biol. 26, 266–276. doi: 10.1111/imb.12292   
Kim, J. H., Yoon, K. S., Previte, D. J., Pittendrigh, B. R., Clark, J. M., and Lee, S. H. (2012). Comparison of the immune response in alimentary tract tissues from body versus head lice following Escherichia coli oral infection. J. Asia Pac. Entomol. 15, 409–412. doi: 10.1016/j.aspen.2012.05.010   
Kirkness, E. F., Haas, B. J., Sun, W., Braig, H. R., Perotti, M. A., Clark, J. M., et al. (2010). Genome sequences of the human body louse and its primary endosymbiont provide insights into the permanent parasitic lifestyle. Proc. Natl. Acad. Sci. U.S.A. 107, 12168–12173. doi: 10.1073/pnas.1003379107   
Kittler, R., Kayser, M., and Stoneking, M. (2003). Molecular evolution of Pediculus humanus and the origin of clothing. Curr. Biol. 13, 1414–1417. doi: 10.1016/S0960-9822(03)00507-4   
Kwon, D. H., Kim, J. H., Kim, Y. H., Yoon, K. S., Clark, J. M., and Lee, S. H. (2014). Identification and characterization of an esterase involved in malathion resistance in the head louse Pediculus humanus capitis. Pestic. Biochem. Physiol. 112, 13–18. doi: 10.1016/j.pestbp.2014.05.006   
La Scola, B., Fournier, P.-E., Brouqui, P., and Raoult, D. (2001). Detection and culture of Bartonella quintana, Serratia marcescens, and Acinetobacter spp. from decontaminated human body lice. J. Clin. Microbiol. 39, 1707–1709. doi: 10.1128/JCM.39.5.1707-1709.2001   
La, V. D., Tran-Hung, L., Aboudharam, G., Raoult, D., and Drancourt, M. (2005). Bartonella quintana in domestic cat. Emerg. Infect. Dis. 11, 1287–1289. doi: 10.3201/eid1108.050101   
Lee, S. H., Kang, J. S., Min, J. S., Yoon, K. S., Strycharz, J. P., Johnson, R., et al. (2010). Decreased detoxification genes and genome size make the human body louse an efficient model to study xenobiotic metabolism. Insect Mol. Biol. 19, 599–615. doi: 10.1111/j.1365-2583.2010.01024.x   
Li, H., Liu, W., Zhang, G.-Z., Sun, Z.-Z., Bai, J.-Y., Jiang, B.-G., et al. (2013). Transmission and maintenance cycle of Bartonella quintana among Rhesus Macaques, China. Emerg. Infect. Dis. 19, 297–300. doi: 10.3201/eid1902. 120816   
Li, W., Ortiz, G., Fournier, P.-E., Gimenez, G., Reed, D. L., Pittendrigh, B., et al. (2010). Genotyping of human lice suggests multiple emergencies of body lice from local head louse populations. PLoS Negl. Trop. Dis. 4:e641. doi: 10.1371/journal.pntd.0000641   
Light, J. E., Allen, J. M., Long, L. M., Carter, T. E., Barrow, L., Suren, G., et al. (2008a). Geographic distributions and origins of human head lice (Pediculus humanus capitis) based on mitochondrial data. J. Parasitol. 94, 1275–1281. doi: 10.1645/GE-1618.1   
Light, J. E., Toups, M. A., and Reed, D. L. (2008b). What’s in a name: the taxonomic status of human head and body lice. Mol. Phylogenet. Evol. 47, 1203–1216. doi: 10.1016/j.ympev.2008.03.014   
Liu, W. T. (1944). Studies on the murine origin of typhus epidemics in North China. 3. Isolation of murine typhus Rickettsia from rats, rat-fleas and body-lice of patients during an epidemic in a poor house. Chin. Med. J. 62, 119–39.   
Louni, M., Amanzougaghene, N., Mana, N., Fenollar, F., Raoult, D., Bitam, I., et al. (2018). Detection of bacterial pathogens in clade E head lice collected from Niger’s refugees in Algeria. Parasit. Vectors 11:348. doi: 10.1186/s13071-018-2930-5   
Lyko, F., Foret, S., Kucharski, R., Wolf, S., Falckenhayn, C., and Maleszka, R. (2010). The honey bee epigenomes: differential methylation of brain DNA in queens and workers. PLoS Biol. 8:e1000506. doi: 10.1371/journal.pbio.1000506   
Mana, N., Louni, M., Parola, P., and Bitam, I. (2017). Human head lice and pubic lice reveal the presence of several Acinetobacter species in Algiers, Algeria. Comp. Immunol. Microbiol. Infect. Dis. 53, 33–39. doi: 10.1016/j.cimid.2017.06.003   
Meinking, T. L., Villar, M. E., Vicaria, M., Eyerdam, D. H., Paquet, D., Mertz-Rivera, K., et al. (2010). The clinical trials supporting benzyl alcohol lotion $5 \%$ (Ulesfia): a safe and effective topical treatment for head lice (Pediculosis humanus capitis). Pediatr. Dermatol. 27, 19–24. doi: 10.1111/j.1525-1470.2009.01059.x   
Molina-Cruz, A., DeJong, R. J., Charles, B., Gupta, L., Kumar, S., JaramilloGutierrez, G., et al. (2008). Reactive oxygen species modulate Anopheles gambiae immunity against bacteria and Plasmodium. J. Biol. Chem. 283, 3217–3223. doi: 10.1074/jbc.M705873200   
Mumcuoglu, K. Y. (2008). “Human lice: Pediculus and Pthirus,” in Paleomicrobiology, eds D. Raoult and M. Drancourt (Berlin: Springer), 215–222. doi: 10.1007/978-3-540-75855-6_13   
Murray, E. S., and Torrey, S. B. (1975). Virulence of Rickettsia prowazeki for head lice. Ann. N.Y. Acad. Sci. 266, 25–34. doi: 10.1111/j.1749-6632.1975.tb35086.x   
Muturi, E. J., Kim, C.-H., Alto, B. W., Berenbaum, M. R., and Schuler, M. A. (2011). Larval environmental stress alters Aedes aegypti competence for Sindbis virus. Trop. Med. Int. Health 16, 955–964. doi: 10.1111/j.1365-3156.2011.02796.x   
Nakka, K., Ghigna, C., Gabellini, D., and Dilworth, F. J. (2018). Diversification of the muscle proteome through alternative splicing. Skelet. Muscle 8:8. doi: 10.1186/s13395-018-0152-3   
Olds, B. P., Coates, B. S., Steele, L. D., Sun, W., Agunbiade, T. A., Yoon, K. S., et al. (2012). Comparison of the transcriptional profiles of head and body lice. Insect Mol. Biol. 21, 257–268. doi: 10.1111/j.1365-2583.2012.01132.x   
Perotti, M. A., Allen, J. M., Reed, D. L., and Braig, H. R. (2007). Host-symbiont interactions of the primary endosymbiont of human head and body lice. FASEB J. 21, 1058–1066. doi: 10.1096/fj.06-6808com   
Perry, G. H. (2014). Parasites and human evolution. Evol. Anthropol. Issues News Rev. 23, 218–228. doi: 10.1002/evan.21427   
Piarroux, R., Abedi, A. A., Shako, J.-C., Kebela, B., Karhemere, S., Diatta, G., et al. (2013). Plague epidemics and lice, Democratic Republic of the Congo. Emerg. Infect. Dis. 19, 505–506. doi: 10.3201/eid1903.121542   
Pittendrigh, B. R., Olds, B. P., Yoon, K. S., Lee, S. H., Sun, W., and Clark, J. M. (2013). The genomics of human lice: from the genome to the potential for future control strategies. Pestic. Biochem. Physiol. 106, 172–176. doi: 10.1016/j.pestbp.2013.03.010   
Previte, D., Olds, B. P., Yoon, K., Sun, W., Muir, W., Paige, K. N., et al. (2014). Differential gene expression in laboratory strains of human head and body lice when challenged with Bartonella quintana, a pathogenic bacterium. Insect Mol. Biol. 23, 244–254. doi: 10.1111/imb.12077   
Raoult, D. (2016). A personal view of how paleomicrobiology aids our understanding of the role of lice in plague pandemics. Microbiol. Spectr. 4:PoH-0001-2014. doi: 10.1128/microbiolspec.PoH-0001-2014   
Raoult, D., Drancourt, M., Carta, A., and Gastaut, J. A. (1994). Bartonella (Rochalimaea) quintana isolation in patient with chronic adenopathy, lymphopenia, and a cat. Lancet Lond. Engl. 343:977. doi: 10.1016/S0140-6736(94)90102-3   
Raoult, D., Dutour, O., Houhamdi, L., Jankauskas, R., Fournier, P.-E., Ardagna, Y., et al. (2006). Evidence for louse-transmitted diseases in soldiers of Napoleon’s Grand Army in Vilnius. J. Infect. Dis. 193, 112–120. doi: 10.1086/498534   
Raoult, D., Reed, D. L., Dittmar, K., Kirchman, J. J., Rolain, J.-M., Guillen, S., et al. (2008). Molecular identification of lice from pre-Columbian mummies. J. Infect. Dis. 197, 535–543. doi: 10.1086/526520   
Raoult, D., and Roux, V. (1999). The body louse as a vector of reemerging human diseases. Clin. Infect. Dis. 29, 888–911. doi: 10.1086/520454   
Reed, D. L., Light, J. E., Allen, J. M., and Kirchman, J. J. (2007). Pair of lice lost or parasites regained: the evolutionary history of anthropoid primate lice. BMC Biol. 5:7. doi: 10.1186/1741-7007-5-7   
Reed, D. L., Smith, V. S., Hammond, S. L., Rogers, A. R., and Clayton, D. H. (2004). Genetic analysis of lice supports direct contact between modern and archaic humans. PLoS Biol. 2:e340. doi: 10.1371/journal.pbio.0020340   
Robinson, D., Leo, N., Prociv, P., and Barker, S. C. (2003). Potential role of head lice, Pediculus humanus capitis, as vectors of Rickettsia prowazekii. Parasitol. Res. 90, 209–211. doi: 10.1007/s00436-003-0842-5   
Rolain, J.-M., Franc, M., Davoust, B., and Raoult, D. (2003). Molecular detection of Bartonella quintana, B. koehlerae, B. henselae, B. clarridgeiae, Rickettsia felis, and Wolbachia pipientis in cat fleas, France. Emerg. Infect. Dis. 9, 338–342. doi: 10.3201/eid0903.020278   
Sangaré, A. K., Boutellis, A., Drali, R., Audoly, G., Weber, P., Rolain, J. M., et al. (2015). Doxycycline kills human lice through its activity on their bacterial symbiont. Int. J. Antimicrob. Agents 45, 675–676. doi: 10.1016/j.ijantimicag.2015.02.008   
Sangaré, A. K., Boutellis, A., Drali, R., Socolovschi, C., Barker, S. C., Diatta, G., et al. (2014). Detection of Bartonella quintana in African body and head lice. Am. J. Trop. Med. Hyg. 91, 294–301. doi: 10.4269/ajtmh. 13-0707   
Sangaré, A. K., Doumbo, O. K., and Raoult, D. (2016a). Management and treatment of human lice. BioMed Res. Int. 2016:8962685. doi: 10.1155/2016/8962685   
Sangaré, A. K., Rolain, J. M., Gaudart, J., Weber, P., and Raoult, D. (2016b). Synergistic activity of antibiotics combined with ivermectin to kill body lice. Int. J. Antimicrob. Agents 47, 217–223. doi: 10.1016/j.ijantimicag.2016.01.001   
Sasaki, T., Poudel, S. K. S., Isawa, H., Hayashi, T., Seki, N., Tomita, T., et al. (2006). First molecular evidence of Bartonella quintana in Pediculus humanus capitis (Phthiraptera: Pediculidae), collected from Nepalese children. J. Med. Entomol. 43, 110–112. doi: 10.1603/0022-2585(2006)043[0110:FMEOBQ]2.0.CO;2   
Sassera, D., Epis, S., Pajoro, M., and Bandi, C. (2013). Microbial symbiosis and the control of vector-borne pathogens in tsetse flies, human lice, and triatomine bugs. Pathog. Glob. Health 107, 285–292. doi: 10.1179/2047773213Y.0000000109   
Sato, S., Kabeya, H., Yoshino, A., Sekine, W., Suzuki, K., Tamate, H. B., et al. (2015). Japanese Macaques (Macaca fuscata) as natural reservoir of Bartonella quintana. Emerg. Infect. Dis. 21, 2168–2170. doi: 10.3201/eid2112. 150632   
Scott, J. G., Michel, K., Bartholomay, L., Siegfried, B. D., Hunter, W. B., Smagghe, G., et al. (2013). Towards the elements of successful insect RNAi. J. Insect Physiol. 59, 1212–1221. doi: 10.1016/j.jinsphys.2013.08.014   
Shao, R., Zhu, X.-Q., Barker, S. C., and Herd, K. (2012). Evolution of extensively fragmented mitochondrial genomes in the lice of humans. Genome Biol. Evol. 4, 1088–1101. doi: 10.1093/gbe/evs088   
Shashindran, C. H., Gandhi, I. S., Krishnasamy, S., and Ghosh, M. N. (1978). Oral therapy of pediculosis capitis with cotrimoxazole. Br. J. Dermatol. 98, 699–700. doi: 10.1111/j.1365-2133.1978.tb03591.x   
Simpson, S. J., Despland, E., Hägele, B. F., and Dodgson, T. (2001). Gregarious behavior in desert locusts is evoked by touching their back legs. Proc. Natl. Acad. Sci. U.S.A. 98, 3895–3897. doi: 10.1073/pnas.071527998   
Sunantaraporn, S., Sanprasert, V., Pengsakul, T., Phumee, A., Boonserm, R., Tawatsin, A., et al. (2015). Molecular survey of the head louse Pediculus humanus capitis in Thailand and its potential role for transmitting Acinetobacter spp. Parasit. Vectors 8:127. doi: 10.1186/s13071-015-0742-4   
Terrapon, N., Li, C., Robertson, H. M., Ji, L., Meng, X., Booth, W., et al. (2014). Molecular traces of alternative social organization in a termite genome. Nat. Commun. 5:3636. doi: 10.1038/ncomms4636   
Toups, M. A., Kitchen, A., Light, J. E., and Reed, D. L. (2011). Origin of clothing lice indicates early clothing use by anatomically modern humans in Africa. Mol. Biol. Evol. 28, 29–32. doi: 10.1093/molbev/msq234   
Tovar-Corona, J. M., Castillo-Morales, A., Chen, L., Olds, B. P., Clark, J. M., Reynolds, S. E., et al. (2015). Alternative splice in alternative lice. Mol. Biol. Evol. 32, 2749–2759. doi: 10.1093/molbev/msv151   
Vallenet, D., Nordmann, P., Barbe, V., Poirel, L., Mangenot, S., Bataille, E., et al. (2008). Comparative analysis of Acinetobacters: three genomes for three lifestyles. PLoS ONE 3:e1805. doi: 10.1371/journal.pone.0001805   
Veracx, A., and Raoult, D. (2012). Biology and genetics of human head and body lice. Trends Parasitol. 28, 563–571. doi: 10.1016/j.pt.2012.09.003   
Weyer, F. (1952). The behavior of Rickettsia akari in the body louse after artificial infection. Am. J. Trop. Med. Hyg. 1, 809–820. doi: 10.4269/ajtmh.1952.1.809   
Yoon, K. S., Strycharz, J. P., Baek, J. H., Sun, W., Kim, J. H., Kang, J. S., et al. (2011). Brief exposures of human body lice to sub-lethal amounts of ivermectin over transcribes detoxification genes involved in tolerance. Insect Mol. Biol. 20, 687–699. doi: 10.1111/j.1365-2583.2011.01097.x

Conflict of Interest: The authors declare that the research was conducted in the absence of any commercial or financial relationships that could be construed as a potential conflict of interest.

Copyright $^ ©$ 2020 Amanzougaghene, Fenollar, Raoult and Mediannikov. This is an open-access article distributed under the terms of the Creative Commons Attribution License (CC BY). The use, distribution or reproduction in other forums is permitted, provided the original author(s) and the copyright owner(s) are credited and that the original publication in this journal is cited, in accordance with accepted academic practice. No use, distribution or reproduction is permitted which does not comply with these terms.